import torch
import numpy as np
import pickle
import time
import pandas as pd
import xlsxwriter
import openpyxl
from scipy.interpolate import lagrange
from config import M, N, n0, n1, n2, numpoints_f2_minus_z, device,KNN
from functions import f1, f2_minus, f2_plus, f_u_plus, f_u_minus,f3_minus, f3_plus, f3_u_minus, f3_u_plus
from functions import calculate_knn_series


# GPU CHOOSE
device = torch.device("cuda" if torch.cuda.is_available() else "cpu")

# Define x, y, and theta values
x_values_0 = torch.linspace(-M, N, n0).to(device)
y_values_0 = torch.linspace(-M, N, n0).to(device)
theta_values_0 = torch.linspace(-M, N, n1).to(device)

# Create tensor for calculating f1, f2_minus, and f2_plus values
tensor_0 = torch.stack([
    x_values_0.unsqueeze(-1).unsqueeze(-1).expand(n0, n0, n1),
    y_values_0.unsqueeze(0).unsqueeze(-1).expand(n0, n0, n1),
    theta_values_0.unsqueeze(0).unsqueeze(0).expand(n0, n0, n1)
], dim=-1).to(device)


knn_results = calculate_knn_series(KNN, n0, n1, n2, M, N, tensor_0, x_values_0, y_values_0,theta_values_0, numpoints_f2_minus_z)


# Open existing Excel file
file_path = 'knn_results.xlsx'
workbook = openpyxl.load_workbook(file_path)
worksheet = workbook.active

# Find the first empty row
def find_first_empty_row(sheet):
    for row in range(1, sheet.max_row + 1):
        if all(cell.value is None for cell in sheet[row]):
            return row
    return sheet.max_row + 1

empty_row = find_first_empty_row(worksheet)

# Write the new results in the first empty row
worksheet.cell(row=empty_row, column=1, value='KNN1')
worksheet.cell(row=empty_row, column=2, value=knn1.item())

# Write the KNN results in the next available rows
for i, (key, value) in enumerate(knn_results.items()):
    worksheet.cell(row=empty_row + i + 1, column=1, value=f"KNN{key}")
    worksheet.cell(row=empty_row + i + 1, column=2, value=value)

# Save the workbook
workbook.save(file_path)
